/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.DSIExtAbstractBooleanExprHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DSIExtSimpleBooleanExprHandler
extends DSIExtAbstractBooleanExprHandler {
    private int m_paramSetCount;

    public DSIExtSimpleBooleanExprHandler(int n) {
        this.m_paramSetCount = n;
    }

    protected abstract boolean passdownSimpleComparison(AEColumnReference var1, DSIExtComparisonValue var2, AEComparisonType var3);

    protected abstract boolean passdownSimpleComparison(AEColumnReference var1, AEColumnReference var2, AEComparisonType var3);

    protected abstract boolean passdownSimpleNullPredicate(AEColumnReference var1, boolean var2);

    protected abstract boolean passdownSimpleInPredicate(AEColumnReference var1, List<DSIExtComparisonValue> var2, boolean var3);

    @Override
    protected boolean passdownComparison(AEComparison aEComparison) {
        assert (null != aEComparison);
        if (aEComparison.getLeftOperand().getNumChildren() == 1 && aEComparison.getRightOperand().getNumChildren() == 1) {
            AEValueExpr aEValueExpr = (AEValueExpr)aEComparison.getLeftOperand().getChild(0);
            AEValueExpr aEValueExpr2 = (AEValueExpr)aEComparison.getRightOperand().getChild(0);
            if (aEValueExpr2 instanceof AEColumnReference && aEValueExpr instanceof AEColumnReference) {
                return this.passdownSimpleComparison((AEColumnReference)aEValueExpr, (AEColumnReference)aEValueExpr2, aEComparison.getComparisonOp());
            }
            AEColumnReference aEColumnReference = null;
            DSIExtComparisonValue dSIExtComparisonValue = null;
            AEComparisonType aEComparisonType = null;
            if (aEValueExpr instanceof AEColumnReference) {
                aEColumnReference = (AEColumnReference)aEValueExpr;
                dSIExtComparisonValue = this.convertToCompValue(aEValueExpr2);
                aEComparisonType = aEComparison.getComparisonOp();
            } else if (aEValueExpr2 instanceof AEColumnReference) {
                aEColumnReference = (AEColumnReference)aEValueExpr2;
                dSIExtComparisonValue = this.convertToCompValue(aEValueExpr);
                aEComparisonType = aEComparison.getComparisonOp().flip();
            }
            if (aEColumnReference == null || dSIExtComparisonValue == null || aEComparisonType == null) {
                return false;
            }
            return this.passdownSimpleComparison(aEColumnReference, dSIExtComparisonValue, aEComparisonType);
        }
        return false;
    }

    @Override
    protected boolean passdownInPredicate(AEInPredicate aEInPredicate) {
        return this.passdownInPredicate(aEInPredicate, true);
    }

    @Override
    protected boolean passdownNot(AENot aENot) {
        assert (null != aENot);
        AEBooleanExpr aEBooleanExpr = aENot.getOperand();
        if (aEBooleanExpr instanceof AENullPredicate) {
            Object t;
            AENullPredicate aENullPredicate = (AENullPredicate)aEBooleanExpr;
            if (1 == aENullPredicate.getOperand().getNumChildren() && (t = aENullPredicate.getOperand().getChild(0)) instanceof AEColumnReference) {
                AEColumnReference aEColumnReference = (AEColumnReference)t;
                return this.passdownSimpleNullPredicate(aEColumnReference, false);
            }
        } else if (aEBooleanExpr instanceof AEInPredicate) {
            AEInPredicate aEInPredicate = (AEInPredicate)aEBooleanExpr;
            return this.passdownInPredicate(aEInPredicate, false);
        }
        return false;
    }

    @Override
    protected boolean passdownNullPredicate(AENullPredicate aENullPredicate) {
        Object t;
        assert (null != aENullPredicate);
        if (1 == aENullPredicate.getOperand().getNumChildren() && (t = aENullPredicate.getOperand().getChild(0)) instanceof AEColumnReference) {
            AEColumnReference aEColumnReference = (AEColumnReference)t;
            return this.passdownSimpleNullPredicate(aEColumnReference, true);
        }
        return false;
    }

    private DSIExtComparisonValue convertToCompValue(AEValueExpr aEValueExpr) {
        assert (null != aEValueExpr);
        if (aEValueExpr instanceof AELiteral) {
            DataWrapper dataWrapper = new DataWrapper();
            dataWrapper.setChar(((AELiteral)aEValueExpr).getStringValue());
            return new DSIExtComparisonValue(((AELiteral)aEValueExpr).getColumn(), dataWrapper, false);
        }
        if (aEValueExpr instanceof AENegate) {
            AENegate aENegate = (AENegate)aEValueExpr;
            if (aENegate.getOperand() instanceof AELiteral) {
                AELiteral aELiteral = (AELiteral)aENegate.getOperand();
                DataWrapper dataWrapper = new DataWrapper();
                dataWrapper.setChar(aELiteral.getStringValue());
                return new DSIExtComparisonValue(aELiteral.getColumn(), dataWrapper, true);
            }
            if (aENegate.getOperand() instanceof AEParameter) {
                if (this.m_paramSetCount == 1) {
                    AEParameter aEParameter = (AEParameter)aENegate.getOperand();
                    return new DSIExtComparisonValue(aEParameter.getColumn(), aEParameter.getInputData(), true);
                }
                if (this.m_paramSetCount == 0) {
                    throw new IllegalStateException(" The parameter set count is not correct. It shouldn't be zero.");
                }
            }
            return null;
        }
        if (aEValueExpr instanceof AEParameter) {
            AEParameter aEParameter = (AEParameter)aEValueExpr;
            if (this.m_paramSetCount == 1) {
                if (null != aEParameter.getInputData()) {
                    return new DSIExtComparisonValue(aEParameter.getColumn(), aEParameter.getInputData(), false);
                }
            } else if (this.m_paramSetCount == 0) {
                throw new IllegalStateException(" The parameter set count is not correct. It shouldn't be zero.");
            }
            return null;
        }
        return null;
    }

    private boolean passdownInPredicate(AEInPredicate aEInPredicate, boolean bl) {
        assert (null != aEInPredicate);
        AEValueExprList aEValueExprList = aEInPredicate.getLeftOperand();
        IAENode iAENode = aEInPredicate.getRightOperand();
        if (1 == aEValueExprList.getNumChildren() && aEValueExprList.getChild(0) instanceof AEColumnReference && iAENode instanceof AEValueExprList) {
            AEColumnReference aEColumnReference = (AEColumnReference)aEValueExprList.getChild(0);
            ArrayList<DSIExtComparisonValue> arrayList = new ArrayList<DSIExtComparisonValue>();
            AEValueExprList aEValueExprList2 = (AEValueExprList)iAENode;
            Iterator iterator = aEValueExprList2.getChildItr();
            AEValueExpr aEValueExpr = null;
            DSIExtComparisonValue dSIExtComparisonValue = null;
            while (iterator.hasNext()) {
                aEValueExpr = (AEValueExpr)iterator.next();
                dSIExtComparisonValue = this.convertToCompValue(aEValueExpr);
                if (null != dSIExtComparisonValue) {
                    arrayList.add(dSIExtComparisonValue);
                    continue;
                }
                return false;
            }
            return this.passdownSimpleInPredicate(aEColumnReference, arrayList, bl);
        }
        return false;
    }

    public static class DSIExtComparisonValue {
        private IColumn m_compMetaData;
        private DataWrapper m_compData;
        private boolean m_isNegate;

        private DSIExtComparisonValue(IColumn iColumn, DataWrapper dataWrapper, boolean bl) {
            this.m_compMetaData = iColumn;
            this.m_compData = dataWrapper;
            this.m_isNegate = bl;
        }

        public IColumn getCompMetaData() {
            return this.m_compMetaData;
        }

        public DataWrapper getData() {
            return this.m_compData;
        }

        public boolean isNegate() {
            return this.m_isNegate;
        }
    }
}

