/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.metadata;

import com.cloudera.hiveserver1.dsi.core.impl.DSIDriver;
import com.cloudera.hiveserver1.dsi.dataengine.filters.IFilter;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver1.dsi.utilities.DSIMessageKey;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.Identifier;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;

public class DSIExtColumnsMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private SqlDataEngine m_dataEngine;
    private List<? extends IColumn> m_currentColumns;
    private int m_currentColumnIndex;

    @Deprecated
    public DSIExtColumnsMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, sqlDataEngine.getIsODBC2());
        this.init(iLogger, sqlDataEngine);
    }

    public DSIExtColumnsMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.TABLE_NAME, sqlDataEngine.getIsODBC2(), list);
        this.init(iLogger, sqlDataEngine);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_currentColumns = null;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        IColumn iColumn = this.m_currentColumns.get(this.m_currentColumnIndex);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getSchemaName(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getTableName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getName(), dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.NormalizeDateTimeTypeForODBC2(iColumn.getTypeMetadata().getType()));
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.getTypeMetadata().getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger((int)TypeUtilities.getColumnSize(iColumn.getTypeMetadata(), iColumn.getColumnLength()));
                return false;
            }
            case BUFFER_LENGTH: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                short s = typeMetadata.getType();
                long l3 = -8 == s || -9 == s || -10 == s ? iColumn.getColumnLength() * 2L : (typeMetadata.isCharacterOrBinaryType() ? iColumn.getColumnLength() : (long)TypeUtilities.getSizeInBytes(s));
                dataWrapper.setInteger(l3);
                return false;
            }
            case DECIMAL_DIGITS: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                if (typeMetadata.isIntervalType() || 92 == typeMetadata.getType() || 93 == typeMetadata.getType()) {
                    dataWrapper.setSmallInt(typeMetadata.getPrecision());
                } else if (typeMetadata.isExactNumericType()) {
                    dataWrapper.setSmallInt(typeMetadata.getScale());
                } else if (typeMetadata.isIntegerType()) {
                    dataWrapper.setSmallInt(0);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                Integer n = typeMetadata.isIntegerType() || typeMetadata.isExactNumericType() ? Integer.valueOf(10) : (typeMetadata.isApproximateNumericType() ? Integer.valueOf(2) : null);
                dataWrapper.setSmallInt(n);
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(iColumn.getNullable().ordinal());
                return false;
            }
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case COLUMN_DEF: {
                dataWrapper.setNull(12);
                return false;
            }
            case SQL_DATA_TYPE: {
                short s = iColumn.getTypeMetadata().getType();
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(s));
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = iColumn.getTypeMetadata().getType();
                short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                if (0 == s2) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s2);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                short s = typeMetadata.getType();
                if (-8 == s || -9 == s || -10 == s) {
                    dataWrapper.setInteger(iColumn.getColumnLength() * 2L);
                } else if (typeMetadata.isCharacterOrBinaryType()) {
                    dataWrapper.setInteger(iColumn.getColumnLength());
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_currentColumnIndex + 1);
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.nullableToIsNullable(iColumn.getNullable()), dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_AUTOINCREMENT: {
                return DSITypeUtilities.outputVarCharStringData(iColumn.isAutoUnique() ? "YES" : "NO", dataWrapper, l, l2);
            }
            case IS_GENERATEDCOLUMN: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentColumns != null && this.m_currentColumnIndex < this.m_currentColumns.size() || this.hasNextProcedureOrTable();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        do {
            if (this.m_currentColumns == null || this.m_currentColumnIndex >= this.m_currentColumns.size() - 1) continue;
            ++this.m_currentColumnIndex;
            return true;
        } while (this.moveToNextTable());
        return false;
    }

    private boolean moveToNextTable() {
        Identifier identifier;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        while ((identifier = this.getNextProcedureOrTable()) != null) {
            try {
                DSIExtJResultSet dSIExtJResultSet = this.m_dataEngine.openTable(identifier.getCatalog(), identifier.getSchema(), identifier.getName(), OpenTableType.READ_ONLY);
                this.m_currentColumns = dSIExtJResultSet.getSelectColumns();
                this.m_currentColumnIndex = -1;
                return true;
            }
            catch (Exception exception) {
                LogUtilities.logWarning(exception, this.m_logger);
                LogUtilities.logWarning("Previous warning was for table " + identifier.toString(), this.m_logger);
            }
        }
        this.m_currentColumns = null;
        return false;
    }

    private String nullableToIsNullable(Nullable nullable) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{nullable});
        if (nullable == Nullable.NULLABLE) {
            return "YES";
        }
        if (nullable == Nullable.NO_NULLS) {
            return "NO";
        }
        return "";
    }

    private void init(ILogger iLogger, SqlDataEngine sqlDataEngine) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_dataEngine = sqlDataEngine;
    }
}

