/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.parser.parsetree;

import com.cloudera.hiveserver1.sqlengine.SQLEngineGenericContext;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.AbstractPTNonterminalNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTVisitor;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTListType;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.cloudera.hiveserver1.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PTListNode
extends AbstractPTNonterminalNode {
    private final PTListType m_listType;
    private ArrayList<IPTNode> m_children;

    public PTListNode(PTListType pTListType) {
        this.m_listType = pTListType;
        this.m_children = new ArrayList();
    }

    @Override
    public <T> T acceptVisitor(IPTVisitor<T> iPTVisitor) throws ErrorException {
        if (null == iPTVisitor) {
            throw new NullPointerException("Visitor cannot be null");
        }
        return iPTVisitor.visit(this);
    }

    public PTListNode addChild(IPTNode iPTNode) {
        if (null == iPTNode) {
            throw new NullPointerException("Child cannot be null");
        }
        this.m_children.add(iPTNode);
        return this;
    }

    public PTListNode addChildren(Iterator<IPTNode> iterator) {
        IPTNode iPTNode = null;
        while (iterator.hasNext()) {
            iPTNode = iterator.next();
            if (null == iPTNode) {
                throw new NullPointerException("Child cannot be null");
            }
            this.m_children.add(iPTNode);
        }
        return this;
    }

    public IPTNode getChild(int n) throws ErrorException {
        try {
            return this.m_children.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(SQLEngineMessageKey.INVALID_ARGUMENT.name(), (Throwable)indexOutOfBoundsException, ExceptionType.DEFAULT);
        }
    }

    @Override
    public Iterator<IPTNode> getChildItr() {
        return this.m_children.iterator();
    }

    public PTListType getListType() {
        return this.m_listType;
    }

    public List<IPTNode> getImmutableChildList() {
        return Collections.unmodifiableList(this.m_children);
    }

    @Override
    public int numChildren() {
        return this.m_children.size();
    }

    public IPTNode removeChild(int n) throws ErrorException {
        try {
            return this.m_children.remove(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(SQLEngineMessageKey.INVALID_ARGUMENT.name(), (Throwable)indexOutOfBoundsException, ExceptionType.DEFAULT);
        }
    }

    public IPTNode setChild(int n, IPTNode iPTNode) throws ErrorException {
        if (null == iPTNode) {
            throw new NullPointerException("The child cannot be null.");
        }
        try {
            return this.m_children.set(n, iPTNode);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(SQLEngineMessageKey.INVALID_ARGUMENT.name(), (Throwable)indexOutOfBoundsException, ExceptionType.DEFAULT);
        }
    }

    @Override
    public String toString() {
        return this.m_listType.name();
    }
}

