/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.dataengine.utilities;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.Nullable;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterType;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

public class ParameterMetadata {
    protected int m_parameterNumber;
    protected ParameterType m_parameterType;
    protected TypeMetadata m_typeMetadata;
    protected long m_columnLength;
    protected String m_name;
    protected boolean m_isCaseSensitive;
    protected Nullable m_nullable;
    private boolean m_convertInputToString = false;

    public ParameterMetadata(int n, ParameterType parameterType, int n2) throws ErrorException {
        this.m_parameterNumber = n;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = TypeMetadata.createTypeMetadata(n2);
        this.m_columnLength = 0L;
        this.m_name = null;
        this.m_isCaseSensitive = false;
        this.m_nullable = Nullable.NULLABLE;
    }

    public ParameterMetadata(int n, ParameterType parameterType, int n2, boolean bl) throws ErrorException {
        this.m_parameterNumber = n;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = TypeMetadata.createTypeMetadata(n2, bl);
        this.m_columnLength = 0L;
        this.m_name = null;
        this.m_isCaseSensitive = false;
        this.m_nullable = Nullable.NULLABLE;
    }

    public ParameterMetadata(int n, ParameterType parameterType, TypeMetadata typeMetadata, long l, String string, boolean bl, Nullable nullable) {
        this.m_parameterNumber = n;
        this.m_parameterType = parameterType;
        this.m_typeMetadata = typeMetadata;
        this.m_columnLength = l;
        this.m_name = string;
        this.m_isCaseSensitive = bl;
        this.m_nullable = nullable;
    }

    public ColumnMetadata getEquivalentColumnMeta() {
        ColumnMetadata columnMetadata = new ColumnMetadata(this.m_typeMetadata);
        columnMetadata.setCaseSensitive(this.m_isCaseSensitive);
        columnMetadata.setName(this.m_name);
        columnMetadata.setNullable(this.m_nullable);
        try {
            columnMetadata.setColumnLength(this.m_columnLength);
        }
        catch (NumericOverflowException numericOverflowException) {
            assert (false);
            numericOverflowException.printStackTrace();
        }
        return columnMetadata;
    }

    public long getColumnLength() {
        return this.m_columnLength;
    }

    public String getName() {
        return this.m_name;
    }

    public Nullable getNullable() {
        return this.m_nullable;
    }

    public int getParameterNumber() {
        return this.m_parameterNumber;
    }

    public ParameterType getParameterType() {
        return this.m_parameterType;
    }

    public TypeMetadata getTypeMetadata() {
        return this.m_typeMetadata;
    }

    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    public boolean isUnnamed() {
        return null == this.m_name;
    }

    public void setCaseSensitive(boolean bl) {
        this.m_isCaseSensitive = bl;
    }

    public void setColumnLength(long l) {
        this.m_columnLength = l;
    }

    public void setConvertInputToString(boolean bl) {
        this.m_convertInputToString = bl;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setNullable(Nullable nullable) {
        this.m_nullable = nullable;
    }

    public boolean shouldConvertInputToString() {
        return this.m_convertInputToString;
    }
}

