/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.utilities.StringConverter;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.IServerVersion;
import com.cloudera.hiveserver2.hivecommon.IServerVersionUtils;
import com.cloudera.hiveserver2.hivecommon.api.IHiveServerBuffer;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class HiveServer2BaseBuffer
implements IHiveServerBuffer {
    private static final Date today = Calendar.getInstance().getTime();
    public TFetchResultsResp m_hiveServer2Buffer = null;
    protected boolean m_isBufferInitialized = false;
    public ILogger m_logger = null;
    protected int m_numRows = 0;
    public HiveJDBCSettings m_settings;

    public HiveServer2BaseBuffer(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        this.m_logger = iLogger;
        this.m_settings = hiveJDBCSettings;
    }

    @Override
    public abstract boolean getData(int var1, long var2, long var4, DataWrapper var6, int var7, short var8, String var9, HiveJDBCSettings var10) throws ErrorException;

    public TFetchResultsResp getHiveServer2Buffer() {
        return this.m_hiveServer2Buffer;
    }

    public abstract List<Integer> getIntColumn(int var1) throws ErrorException;

    public abstract int getNumColumns();

    @Override
    public int getNumRowsInBuffer() {
        return this.m_numRows;
    }

    public abstract List<String> getStringColumn(int var1) throws ErrorException;

    @Override
    public final void initializeBuffer() throws ErrorException {
        if (!this.m_isBufferInitialized) {
            this.setNumRows();
            this.handleInitializeBuffer();
            this.m_isBufferInitialized = true;
        }
    }

    @Override
    public boolean isGetNextBuffer(int n) throws ErrorException {
        return n >= this.m_numRows;
    }

    @Override
    public void parseRow(int n) throws ErrorException {
    }

    public void setHiveServer2Buffer(TFetchResultsResp tFetchResultsResp) {
        this.m_hiveServer2Buffer = tFetchResultsResp;
        this.m_isBufferInitialized = false;
    }

    protected Timestamp convertTimestamp(String string) {
        Timestamp timestamp = null;
        try {
            timestamp = this.m_settings.m_useCustomTimestampConverter.booleanValue() ? StringConverter.parseTimestamp(string, null) : Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IServerVersionUtils iServerVersionUtils = this.m_settings.m_platformVersionUtils;
            IServerVersion iServerVersion = this.m_settings.m_serverVersion;
            if (iServerVersionUtils.supportsTimeOnlyTimestamp(iServerVersion) && this.m_settings.m_supportTimeOnlyTimestamp) {
                try {
                    Time time = StringConverter.parseTime(string, null);
                    if (null != time) {
                        timestamp = new Timestamp(time.getTime());
                        timestamp.setDate(today.getDate());
                        timestamp.setMonth(today.getMonth());
                        timestamp.setYear(today.getYear());
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    java.sql.Date date;
                    if (iServerVersionUtils.supportsDateOnlyTimestamp(iServerVersion) && null != (date = StringConverter.parseDate(string, null))) {
                        return new Timestamp(date.getDate());
                    }
                    throw illegalArgumentException;
                }
            }
            throw illegalArgumentException;
        }
        return timestamp;
    }

    protected abstract void handleInitializeBuffer() throws ErrorException;

    protected abstract void setNumRows() throws ErrorException;
}

