/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.conversions;

import com.cloudera.hiveserver2.dsi.dataengine.impl.DSISimpleArray;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IArray;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver2.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver2.support.conv.ConversionResult;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.lang.reflect.Array;

public class SqlArrayConverter
implements ISqlConverter {
    private final IColumn m_sourceColumnMetadata;
    private ColumnMetadata m_sourceBaseColumnMetadata;
    private final IColumn m_targetColumnMetadata;
    private ColumnMetadata m_targetBaseColumnMetadata;
    private final short m_targetType;
    private ISqlConverter m_baseTypeConverter;

    public SqlArrayConverter(IColumn iColumn, IColumn iColumn2) throws ErrorException {
        block10: {
            TypeMetadata typeMetadata;
            block9: {
                this.m_sourceBaseColumnMetadata = null;
                this.m_targetBaseColumnMetadata = null;
                this.m_baseTypeConverter = null;
                if (iColumn.getTypeMetadata().getType() != 2003 || iColumn2.getTypeMetadata().getType() != 2003) {
                    throw SQLEngineExceptionFactory.featureNotImplementedException("SqlArrayConverter only support conversion between one dimensional arrays.");
                }
                this.m_sourceColumnMetadata = iColumn;
                this.m_targetColumnMetadata = iColumn2;
                TypeMetadata typeMetadata2 = iColumn.getTypeMetadata().getNestedColumnList().get(0).getTypeMetadata();
                typeMetadata = iColumn2.getTypeMetadata().getNestedColumnList().get(0).getTypeMetadata();
                int n = 1;
                int n2 = 1;
                while (typeMetadata2.getType() == 2003) {
                    typeMetadata2 = typeMetadata2.getNestedColumnList().get(0).getTypeMetadata();
                    ++n;
                }
                while (typeMetadata.getType() == 2003) {
                    typeMetadata = typeMetadata.getNestedColumnList().get(0).getTypeMetadata();
                    ++n2;
                }
                if (n != n2) {
                    throw SQLEngineExceptionFactory.conversionNotSupported(n + "-D array", n2 + "-D array");
                }
                this.m_sourceBaseColumnMetadata = new ColumnMetadata(typeMetadata2);
                try {
                    this.m_sourceBaseColumnMetadata.setColumnLength(this.m_sourceColumnMetadata.getColumnLength());
                }
                catch (NumericOverflowException numericOverflowException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)"Fail to copy the column length to base source column of an array");
                }
            }
            this.m_targetBaseColumnMetadata = new ColumnMetadata(typeMetadata);
            try {
                this.m_targetBaseColumnMetadata.setColumnLength(this.m_targetColumnMetadata.getColumnLength());
            }
            catch (NumericOverflowException numericOverflowException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)"Fail to copy the column length to base target column of an array");
            }
        }
        this.m_targetType = this.m_targetBaseColumnMetadata.getTypeMetadata().getType();
        if (this.m_sourceBaseColumnMetadata.getTypeMetadata().getType() != this.m_targetBaseColumnMetadata.getTypeMetadata().getType()) {
            SqlConverterGenerator sqlConverterGenerator = new SqlConverterGenerator();
            this.m_baseTypeConverter = sqlConverterGenerator.createConverter(this.m_sourceBaseColumnMetadata, this.m_targetBaseColumnMetadata);
        }
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        if (null == this.m_baseTypeConverter) {
            iSqlDataWrapper2.setArray(iSqlDataWrapper.getArray());
        } else {
            Object[] objectArray = (Object[])iSqlDataWrapper.getArray().createArray(0L, -1);
            short s = this.m_sourceBaseColumnMetadata.getTypeMetadata().getType();
            short s2 = this.m_targetBaseColumnMetadata.getTypeMetadata().getType();
            int n = TypeUtilities.getDimensionofArray(iSqlDataWrapper.getArray());
            Object[] objectArray2 = this.convertArrayHelper(objectArray, n, s, s2, conversionResult);
            DSISimpleArray dSISimpleArray = new DSISimpleArray(objectArray2, this.m_targetColumnMetadata);
            iSqlDataWrapper2.setArray(dSISimpleArray);
        }
        return conversionResult;
    }

    protected Object[] convertArrayHelper(Object[] objectArray, int n, short s, short s2, ConversionResult conversionResult) throws ErrorException {
        Object[] objectArray2;
        if (n > 0) {
            Object[] objectArray3 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                IArray iArray = (IArray)Array.get(objectArray, i);
                Object[] objectArray4 = (Object[])iArray.createArray(0L, -1);
                objectArray3[i] = this.convertArrayHelper(objectArray4, n - 1, s, s2, conversionResult);
            }
            objectArray2 = objectArray3;
        } else {
            ISqlDataWrapper iSqlDataWrapper = DefaultSqlDataWrapper.initializeFromSqlType(s);
            ISqlDataWrapper iSqlDataWrapper2 = DefaultSqlDataWrapper.initializeFromSqlType(s2);
            DataWrapper dataWrapper = new DataWrapper();
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    dataWrapper.setData(s, objectArray[i]);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString(s), TypeUtilities.sqlTypeToString(this.m_targetType));
                }
                iSqlDataWrapper.setValue(dataWrapper);
                DataWrapper dataWrapper2 = new DataWrapper();
                dataWrapper2.setNull(s2);
                iSqlDataWrapper2.setValue(dataWrapper2);
                ConversionResult conversionResult2 = this.m_baseTypeConverter.convert(iSqlDataWrapper, iSqlDataWrapper2);
                if (conversionResult.getState() == ConversionResult.TypeConversionState.SUCCESS && conversionResult2.getState() != ConversionResult.TypeConversionState.SUCCESS) {
                    conversionResult.setState(conversionResult2.getState());
                }
                DataWrapper dataWrapper3 = new DataWrapper();
                dataWrapper3.setNull(s2);
                iSqlDataWrapper2.retrieveData(dataWrapper3);
                objectArray2[i] = dataWrapper3.getObject();
            }
        }
        return objectArray2;
    }
}

